
; **************************************************************************
; === Define constants ===
; **************************************************************************
!define VER 		"0.0.0.0"	; version of launcher
!define APPNAME 	"FileZilla"	; complete name of program
!define APP 		"FileZilla"	; short name of program without space and accent  this one is used for the final executable an in the directory structure
!define APPEXE 		"filezilla.exe"	; main exe name
!define APPDIR 		"App\FileZilla"	; main exe relative path
!define APPEXE64 	"filezilla.exe"	; main exe 64 bit name
!define APPDIR64 	"App\FileZilla64"	; main exe 64 bit relative path
!define APPSWITCH 	``	; some default Parameters

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "TextReplace.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}Portable.exe"
Icon "${APP}.ico"


; **************************************************************************
; === Other Actions ===
; **************************************************************************
Function Init
IfFileExists "$EXEDIR\${APPDIR}\fzdefaults.xml" +2
File "/oname=$EXEDIR\${APPDIR}\fzdefaults.xml" fzdefaults.xml
IfFileExists "$EXEDIR\${APPDIR64}\fzdefaults.xml" +2
File "/oname=$EXEDIR\${APPDIR64}\fzdefaults.xml" fzdefaults.xml

	nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}" "${APPNAME} Portable 32 bit"
	nsisFirewall::AddAuthorizedApplication "$EXEDIR\${APPDIR64}\${APPEXE64}" "${APPNAME} Portable 64 bit"

ReadINIStr $0 "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "LastDirectory"
StrCpy $1 $0 3
StrCpy $2 $EXEDIR 3
StrCmp $1 $2 +4
	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\filezilla.xml" "$EXEDIR\Data\${APP}\filezilla.xml" "$1" "$2" "" $0
	${textreplace::ReplaceInFile} "$EXEDIR\Data\${APP}\sitemanager.xml" "$EXEDIR\Data\${APP}\sitemanager.xml" "$1" "$2" "" $0
	${textreplace::Unload}

FunctionEnd

Function Close
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR}\${APPEXE}"
	nsisFirewall::RemoveAuthorizedApplication "$EXEDIR\${APPDIR64}\${APPEXE64}"

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
${GetParameters} $0
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
SetOutPath "$EXEDIR\${APPDIR64}"
ExecWait `"$EXEDIR\${APPDIR64}\${APPEXE64}"${APPSWITCH} $0`
${Else}
SetOutPath "$EXEDIR\${APPDIR}"
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}"${APPSWITCH} $0`
${EndIf}
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd


; **************************************************************************
; ==== Running ====
; **************************************************************************
Function Restore

	Call Close

FunctionEnd

Section "Main"

	Call CheckStart

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

